<?php
/* --------------------------------------------------------------
   ParcelServiceProvidersDescription.inc.inc.php 2020-02-07
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Model;

/**
 * Class ParcelServiceDescription
 *
 * @package Gambio\Admin\ParcelService\Model
 */
class ParcelServiceDescription
{
    /**
     * @var string
     */
    private $url;
    
    /**
     * @var string
     */
    private $comment;
    
    
    /**
     * ParcelServiceProvidersDescription constructor.
     *
     * @param string $url
     * @param string $comment
     */
    private function __construct(string $url, string $comment)
    {
        $this->url     = $url;
        $this->comment = $comment;
    }
    
    
    /**
     * Named constructor of ParcelServiceProvidersDescription.
     *
     * @param string $url
     * @param string $comment
     *
     * @return ParcelServiceDescription
     */
    public static function create(string $url, string $comment): ParcelServiceDescription
    {
        return new self($url, $comment);
    }
    
    
    /**
     * Returns the parcel service url.
     *
     * @return string
     */
    public function url(): string
    {
        return $this->url;
    }
    
    
    /**
     * Returns the parcel service comment.
     *
     * @return string
     */
    public function comment(): string
    {
        return $this->comment;
    }
    
    
    /**
     * Array serialization.
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            'url'     => $this->url,
            'comment' => $this->comment
        ];
    }
    
    
    /**
     * Creates a new parcel service description
     *
     * @param array $data
     *
     * @return ParcelServiceDescription
     */
    public static function createFromArray(array $data): ParcelServiceDescription
    {
        return self::create($data['url'], $data['comment']);
    }
}